package loader;

import org.antlr.v4.runtime.*;

public class ExitOnErrorStrategy extends DefaultErrorStrategy{
    @Override
    public void reportError(Parser recognizer, RecognitionException e) {
        super.reportError(recognizer, e);
        System.err.println("Error in line " + e.getOffendingToken().getLine() +" in symbol " + e.getOffendingToken().getCharPositionInLine());
        System.exit(1); //
    }
}
